<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */
    
    session_start();
    include "../../include/costanti.php";
    include "../../include/util.php";
    include "../../include/utilEcommerce.php";
    include "../../gUtil/DbManager.php";
    include "../../gUtil/GeneratoreEmail.php";
    include "../../classi/ecommerce/Ordine.php";
    include "../../classi/ecommerce/Carrello.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $datiGeecomCMS = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    $cartellaAMministrativaCMS = str_replace("../","", $datiGeecomCMS["percorso"]);
    $impostazioniEmail         = recuperaImpostazioniEmail($geecomDb);
    $generatoreEmail           = new GeneratoreEmail($impostazioniEmail["nomeMittente"],$impostazioniEmail["emailMittente"],$rispondiA);
    
    if(isset($_GET["operazione"])) {
        $operazione = filter_input(INPUT_GET, "operazione",FILTER_SANITIZE_STRING);
        $idOrdine   = filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT);
        $ordine     = new Ordine($geecomDb, $idOrdine);
    }
    else {
        $operazione = filter_input(INPUT_POST, "operazione",FILTER_SANITIZE_STRING);
        $idOrdine   = filter_input(INPUT_POST, "id",FILTER_SANITIZE_NUMBER_INT);
        $ordine     = new Ordine($geecomDb, $idOrdine);
    }
    
    $datiOrdine = $geecomDb->leggiSingolaRiga("geecEc_ordini", $idOrdine);
    $arrayDestinatario = explode(" ",$datiOrdine["destinatario"]);
    $nomeDestinatario  = $arrayDestinatario[0];
        
    if($operazione=="elimina") {
       $ordine->elimina();
       echo "ok";
    }
    else if($operazione=="modifica") {
        $codiceTracciamento = filter_input(INPUT_POST, "codiceTracciamento",FILTER_SANITIZE_STRING);
        $stato              = filter_input(INPUT_POST, "stato",FILTER_SANITIZE_STRING);
        $ordine->caricaDatiDalDatabase();
        
        // se imposto un ordine come annullato creo l'istanza del carrello e ripristino le quantità a prima della vendita 
        if($ordine->getStato()=="in attesa di pagamento" && $stato=="annullato") {
            $carrello = new Carrello($geecomDb, $datiOrdine["idCarrello"]);
            $carrello->caricaDatiDalDatabase();
            $carrello->ripristinaDisponibilitaNegozio();
        }
        
        if($stato == "spedito") {
            $ordine->setStato($stato);
            $ordine->setCodiceTracciamento($codiceTracciamento);
            $ordine->modifica();
            echo "ok";

            $oggetto = "Ordine spedito";
            $messaggio = "Ciao $nomeDestinatario, <br><br> il tuo ordine {$datiOrdine["id"]} è stato impostato come $stato.<br><br>"
                        . "Il codice di tracciamento è $codiceTracciamento<br><br>";
            
            $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);
            
            $corpoMail = str_replace("testo_da_inserire",$messaggio,$datiEmail['corpoMail']);
            $messaggioHTML = "<!doctype html>
                    <html>
                      <head>
                        <meta name=\"viewport\" content=\"width=device-width\" />
                        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                        <title>$oggetto</title>
                        <style>
                            {$datiEmail['css']}
                        </style>
                      </head>
                      <body class=\"\">
                    </body>
                    $corpoMail
                    {$datiEmail['footerMail']}";
                    
            $generatoreEmail->invia($datiOrdine["email"], $oggetto, $messaggioHTML);
        }
        else {
            $ordine->setStato($stato);
            $ordine->setCodiceTracciamento($codiceTracciamento);
            $ordine->modifica();
            echo "ok";
        }
    }
    else if($operazione=="modificaStato") {
        $idOrdine = filter_input(INPUT_POST, "id",FILTER_SANITIZE_NUMBER_INT);
        $stato    = filter_input(INPUT_POST, "stato",FILTER_SANITIZE_STRING);
            
        // se imposto un ordine come annullato creo l'istanza del carrello e ripristino le quantità a prima della vendita 
        if($datiOrdine["stato"]=="in attesa di pagamento" && $stato=="annullato") {
            $carrello = new Carrello($geecomDb, $datiOrdine["idCarrello"]);
            $carrello->caricaDatiDalDatabase();
            $carrello->ripristinaDisponibilitaNegozio();
        }
        
        if($stato == "spedito") {
            //se l'ordine è pagato viene modificato allo stato di spedito, altrimenti da un errore
            $queryModificaOrdine = "UPDATE geecEc_ordini SET stato='spedito' WHERE id=$idOrdine";
            $geecomDb->eseguiQueryLettura($queryModificaOrdine);
            echo "ok";

            $oggetto = "Ordine spedito";
            $messaggio = "Ciao $nomeDestinatario, <br><br> il tuo ordine {$datiOrdine["id"]} è stato impostato come $stato.<br><br>";
            
            $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);
            
            $corpoMail = str_replace("testo_da_inserire",$messaggio,$datiEmail['corpoMail']);
            $messaggioHTML = "<!doctype html>
                    <html>
                      <head>
                        <meta name=\"viewport\" content=\"width=device-width\" />
                        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                        <title>$oggetto</title>
                        <style>
                            {$datiEmail['css']}
                        </style>
                      </head>
                      <body class=\"\">
                    </body>
                    $corpoMail
                    {$datiEmail['footerMail']}";
                    
            $generatoreEmail->invia($datiOrdine["email"], $oggetto, $messaggioHTML);
        }
        else {
            $queryModificaOrdine = "UPDATE geecEc_ordini SET stato='$stato' WHERE id=$idOrdine";
            $geecomDb->eseguiQueryScrittura($queryModificaOrdine);
            echo "ok";
        }
    }
